; Diagnostic ROM part 3
; Test 3 KeyBd 
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
TEMP	= 	  $F8
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A

; Test 3 KeyBd
;  Switch setting:
;  S6 on
; --
;  S0 off
;  S1 off
;  S2 on
;  S3 on
;This is used to test the keyboard. It test all the buttons.
;Pressing RS will restart the test. ST will light the green
;light ( use RS to turn it off if you like ).
;The other keys will display the row and column for each button.
;Refer to the schematic for a reference.
;As an example, the E button will display 2 G.
;Try each switch from 0 to GO to see what unique combination
;is created. This test is run with the small, on/off, switch
;on the keyboard in the OFF position.
;This switch can be tested by using the single step function
;as described in the KIM-1 Users manual, with the normal KIM-1
;monitor.
;
;Key table:
;   ROW  COL
;0   0    G
;1   0    F
;2   0    E
;3   0    d
;4   0    c
;5   0    b
;6   0    A
;7   1    G
;8   1    F
;9   1    E
;A   1    d
;B   1    c
;C   1    b
;D   1    A
;E   2    G
;F   2    F
;AD  2    E
;DA  2    d
;PC  2    A
;+   2    c
;GO  2    b


	.ORG $0C00

TABLE    
		  
        .byte $BF
        .byte $86
        .byte $DB
        .byte $CF
        .byte $E6
        .byte $ED
        .byte $FD
        .byte $87
        .byte $FF
        .byte $EF
        .byte $F7
        .byte $FC
        .byte $B9
        .byte $DE
        .byte $F9
        .byte $F1
        .byte $00
        .byte $BD
        .byte $F1
        .byte $F9
        .byte $DE
        .byte $D8
        .byte $FC
        .byte $F7

;		  
;		  
;		  
L0C18     STX $00
          LDY #$08
L0C1C     DEY			; first determine column
          LSR A			; find the zero bit
          BCS L0C1C
          TYA
          CLC
          ADC #$10
          STA $06
          LDA $00
          LSR A			; divide x by 2 to get row
          STA $03
;
; Init RRIOT ports
;		  
          LDX #$00
          STX $1740		; all off
          LDX #$FF
          STX $1741		; set port to out
          LDX #$3F
          STX $1743
          LDX #$13		; 9 2 * 1 + first plus TTY
          STX $1742		; port A out
          LDY #$05		; number of digits to scan  (6)
L0C41     LDA $0002,Y
          STY $01
          TAY
          LDA $0C00,Y
          LDY #$00
          STY $1740		; off
          STX $1742		; digit
          STA $1740		; seg on
          LDY #$FF		; delay
L0C57     DEY
          BNE L0C57
          DEX			; add 2 to advance digit
          DEX
          LDY $01
          DEY
          BNE L0C41
          LDX #$00
          STX $1742		; PORT A input
          STX $1741
          LDX #$05
          STX $1742
          RTS
;		  
RESET     LDY #$02
          LDX #$06		; scan keybaord
          LDA #$10		; blank display
LTABL     STA $0000,Y	; fill table in zeropage
          INY
          DEX
          BNE LTABL
;		  
          LDX #$FF
          TXS
          CLC
          LDX #$00			; clear RRIOT
          STX $1741
          STX $1740
          LDX #$3F
          STX $1743
          LDX #$05
L0C8F     STX $1742
          LDA $1740
          AND #$7F
          CMP #$7F
          BEQ L0C9E
          JSR L0C18
;		  
L0C9E     DEX
          DEX
          BPL L0CA4
          LDX #$05
L0CA4     JMP L0C8F
;
; IRQ
;
NMI       LDA #$01			; light LED
          STA $1000
          JMP RESET
;
;
HEREV
		.FILL (VECTOR - HEREV)&$FFF, 0
		  .ORG $FFFA
VECTOR		  

          .BYTE NMI&255
          .BYTE NMI/256
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256


;
; Reset vectors
;	

;          .BYTE RESET&255
;          .BYTE RESET/256
;          .BYTE RESET&255
;          .BYTE RESET/256
;          .BYTE RESET&255
;          .BYTE RESET/256
		 .END